/* 
 * fork-wait.c 
 *
 * Створює дочірній процес і передає повідомлення від дочірнього процесу 
 * батьківському. Отримане від дочірнього процесу повідомлення 
 * батьківський процес виводить у стандартний потік виведення результатів.
 * Ілюструє порядок застосування функцій fork(), wait().
 *
 */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

enum { MSGSIZE = 20 };          /* Розмір повідомлення */


int main()
{
        pid_t child_pid;
        FILE *stream;

        printf("Parent: The main program's PID is %u\n",
                                        (unsigned int) getpid());

        /* Створює тимчасовий файл. */ 
        stream = tmpfile();
        if (stream == NULL) {
                fprintf(stderr, "Parent: Can't create temporary file:"
                                                " %s\n", strerror(errno));
                exit(EXIT_FAILURE);
        }

        /* Створює дочірній процес. */
        child_pid = fork();
        if (child_pid != 0) {
                /* Це батьківський процес */
                int child_status;
                char message[MSGSIZE];

                if (child_pid == -1) {
                        /* Помилка при створенні дочірнього процесу */
                        fprintf(stderr, "Parent: Error creating a child:"
                                                " %s\n", strerror(errno));
                        exit(EXIT_FAILURE);
                }
                printf("Parent: My PID is %u and my child's PID is %u\n",
                                                (unsigned int) getpid(),
                                                (unsigned int) child_pid);
                /* Чекає на завершення дочірнього процесу. */
                wait(&child_status);
                /* Виводить код завершення дочірнього процесу. */
                printf("Parent: Child exited with code %d\n",
                                                        child_status);
                /* Намагається отримати повідомлення від дочірнього
                   процесу. */
                if (fseek(stream, 0, SEEK_SET) != 0) {
                        fprintf(stderr, "Parent: Error seeking in"
                                " temporary file: %s\n", strerror(errno));
                        exit(EXIT_FAILURE);
                }
                if (fgets(message, MSGSIZE, stream) == NULL) {
                        if (ferror(stream)) {
                                fprintf(stderr, "Parent: Error reading from"
                                " temporary file: %s\n", strerror(errno));
                                exit(EXIT_FAILURE);
                        }
                        printf("Parent: No message from child has been"
                                                        " received\n");
                        exit(EXIT_SUCCESS);
                }
                /* Виводить повідомлення, отримане від дочірнього процесу. */
                printf("Parent: A message from child has been received:\n"
                                                        "%s\n", message);
        } else {
                /* Це дочірній процес */
                printf("Child: My PID is %u and my parent's PID is %u\n",
                                                (unsigned int) getpid(),
                                                (unsigned int) getppid());
                /* Передає повідомлення батьківському процесу. */
                if (fputs("Hello, Daddy!", stream) == EOF) {
                        fprintf(stderr, "Child: Error writing to temporary"
                                        " file: %s\n", strerror(errno));
                        exit(EXIT_SUCCESS);
                }
        }	
        exit(EXIT_SUCCESS);	
}
